#Déclaration des librairies
import sys
import os
import glob

#Récupération du modèle anglais :
nlp = spacy.load('en_core_web_sm')

#Le fichier de Dragon Age étant trop grand pour l'analyse de Spacy, lecture de
#l'ensemble des sous-fichiers dans le dossier Sous-parties.
liste = glob.glob('Sous_parties/*.txt')
#Le fichier où seront inscrits les résultats est ouvert en "append" afin
#que chaque résultat soit écrit sans effacer le précédent.
fichier = open("DAO_NER_resultats.txt", "a")

#Boucle de lecture de tous les sous-fichiers :
for el in liste:
    #Qui sont transformés en objet Spacy et lus
    el = nlp(open(el).read())
    #Boucle de recherche des entités nommées :
    for ent in el.ents:
        #Je récupère le texte de l'EN ainsi que le label attribué par Spacy.
        resultat = [ent.text, ent.label_]
        #Je transforme la liste en string afin de permettre son écriture.
        resultat = " ".join(resultat)
        fichier.write(resultat)
        #J'inscris un saut de ligne après chaque résultat pour la lisibilité.
        fichier.write('\n')
